<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model 
{

    protected $table = 'offers';
    public $timestamps = true;
    protected $fillable = array('title_ar', 'title_en', 'desc_ar', 'desc_en', 'price');

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'photoable');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment');
    }

}